#******************************************************************************
#
#    ＊ ベンチマーク
#
#  --------------------------------------------------------------------------
#    バージョン ：  1.1.0
#    対      応 ：  RPGツクールVX Ace : RGSS3
#    制  作  者 ：  ＣＡＣＡＯ
#    配  布  元 ：  http://cacaosoft.web.fc2.com/
#  --------------------------------------------------------------------------
#   == 概    要 ==
#
#    ： 特定の処理にかかる時間を測定する機能を追加します。
#
#  --------------------------------------------------------------------------
#   == 注意事項 ==
#
#    ※ 測定結果は、コンソールウィンドウに出力されます。
#
#  --------------------------------------------------------------------------
#   == 使用方法 ==
#
#    ★ 処理時間の測定
#     Benchmark.measure(["名前"]) { 処理 }
#
#    ★ 処理時間の平均を測定
#     Benchmark.benchmark(実行回数[, "名前"]) { 処理 }
#
#    ★ 処理時間の測定 (経過秒数を返す)
#     bm = Benchmark.new
#     bm.start              # 開始/再開
#     bm.stop               # 一時停止
#     bm.reset              # リセット
#     p bm.elapsed          # 経過時間
#     p bm.lap              # ラップタイム
#     p bm.total            # 呼び出されるまでの総時間
#
#
#******************************************************************************


#/////////////////////////////////////////////////////////////////////////////#
#                                                                             #
#                下記のスクリプトを変更する必要はありません。                 #
#                                                                             #
#/////////////////////////////////////////////////////////////////////////////#


class Benchmark
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def initialize
    reset
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def reset
    @start_time = nil
    @last_time  = nil
    @restart_time = nil
    @elapsed_time = 0.0
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def start
    if @start_time
      if @restart_time
        puts "must stop or reset (#{_caller})"
      else
        @last_time    = Time.now
        @restart_time = Time.now
      end
    else
      @start_time   = Time.now
      @last_time    = Time.now
      @restart_time = Time.now
    end
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def stop
    if @start_time && @restart_time
      @elapsed_time += Time.now - @restart_time
      @last_time = nil
      @restart_time = nil
    else
      puts "not started (#{_caller})"
    end
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def elapsed
    if @start_time
      return @elapsed_time
    else
      puts "not started (#{_caller})"
    end
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def total
    if @start_time
      return Time.now - @start_time
    else
      puts "not started (#{_caller})"
    end
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def lap
    if @start_time && @last_time
      lap_time = Time.now - @last_time
      @last_time = Time.now
      return lap_time
    else
      puts "must start (#{_caller})"
    end
  end
  #--------------------------------------------------------------------------
  # ● 
  #--------------------------------------------------------------------------
  def _caller
    match_data = caller[1].match(/^\{(\d+)\}:(\d+):/)
    section = $RGSS_SCRIPTS[match_data[1].to_i][1]
    return "#{section.empty? ? "-" : section}:#{match_data[2].to_i}"
  end
  private :_caller
  
  #--------------------------------------------------------------------------
  # ● 測定
  #--------------------------------------------------------------------------
  def self.measure(name = "Time")
    raise(LocalJumpError, "no block given", caller) unless block_given?
    time = Time.now
    yield
    puts "#{name}: #{Time.now - time} s"
  end
  #--------------------------------------------------------------------------
  # ● 測定 (平均)
  #--------------------------------------------------------------------------
  def self.benchmark(n = 5, name = "Time")
    raise(LocalJumpError, "no block given", caller) unless block_given?
    list = []
    n.times {
      time = Time.now
      yield
      list << Time.now - time
    }
    puts "#{name}: #{list.inject(0.0) {|total,time| total+time }/list.size} s"
  end
end
